/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5599;
import net.minecraft.class_756;
import net.minecraft.class_811;
import net.minecraft.class_824;
import net.minecraft.class_918;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.texture.AnimatableTexture;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.event.GeoRenderEvent;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayersContainer;
import software.bernie.geckolib.util.RenderUtils;

public class GeoItemRenderer<T extends class_1792>
extends class_756
implements GeoRenderer<T> {
    protected final GeoRenderLayersContainer<T> renderLayers = new GeoRenderLayersContainer(this);
    protected final GeoModel<T> model;
    protected class_1799 currentItemStack;
    protected class_811 renderPerspective;
    protected T animatable;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;
    protected boolean useEntityGuiLighting = false;
    protected Matrix4f itemRenderTranslations = new Matrix4f();
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public GeoItemRenderer(GeoModel<T> model) {
        this(class_310.method_1551().method_31975(), class_310.method_1551().method_31974(), model);
    }

    public GeoItemRenderer(class_824 dispatcher, class_5599 modelSet, GeoModel<T> model) {
        super(dispatcher, modelSet);
        this.model = model;
    }

    @Override
    public GeoModel<T> getGeoModel() {
        return this.model;
    }

    @Override
    public T getAnimatable() {
        return this.animatable;
    }

    public class_1799 getCurrentItemStack() {
        return this.currentItemStack;
    }

    public GeoItemRenderer<T> useAlternateGuiLighting() {
        this.useEntityGuiLighting = true;
        return this;
    }

    @Override
    public long getInstanceId(T animatable) {
        return GeoItem.getId(this.currentItemStack);
    }

    @Override
    public class_2960 getTextureLocation(T animatable) {
        return GeoRenderer.super.getTextureLocation(animatable);
    }

    @Override
    public List<GeoRenderLayer<T>> getRenderLayers() {
        return this.renderLayers.getRenderLayers();
    }

    public GeoItemRenderer<T> addRenderLayer(GeoRenderLayer<T> renderLayer) {
        this.renderLayers.addLayer(renderLayer);
        return this;
    }

    public GeoItemRenderer<T> withScale(float scale) {
        return this.withScale(scale, scale);
    }

    public GeoItemRenderer<T> withScale(float scaleWidth, float scaleHeight) {
        this.scaleWidth = scaleWidth;
        this.scaleHeight = scaleHeight;
        return this;
    }

    @Override
    public void preRender(class_4587 poseStack, T animatable, BakedGeoModel model, class_4597 bufferSource, class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.itemRenderTranslations = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
        this.scaleModelForRender(this.scaleWidth, this.scaleHeight, poseStack, (GeoAnimatable)animatable, model, isReRender, partialTick, packedLight, packedOverlay);
        if (!isReRender) {
            poseStack.method_46416(0.5f, 0.51f, 0.5f);
        }
    }

    public void method_3166(class_1799 stack, class_811 transformType, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay) {
        this.animatable = stack.method_7909();
        this.currentItemStack = stack;
        this.renderPerspective = transformType;
        if (transformType == class_811.field_4317) {
            this.renderInGui(transformType, poseStack, bufferSource, packedLight, packedOverlay);
        } else {
            class_1921 renderType = this.getRenderType((GeoAnimatable)this.animatable, this.getTextureLocation(this.animatable), bufferSource, class_310.method_1551().method_1488());
            class_4588 buffer = class_918.method_29711((class_4597)bufferSource, (class_1921)renderType, (boolean)false, (this.currentItemStack != null && this.currentItemStack.method_7958() ? 1 : 0) != 0);
            this.defaultRender(poseStack, (GeoAnimatable)this.animatable, bufferSource, renderType, buffer, 0.0f, class_310.method_1551().method_1488(), packedLight);
        }
    }

    protected void renderInGui(class_811 transformType, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay) {
        class_4597.class_4598 bufferSource2;
        this.setupLightingForGuiRender();
        class_4597.class_4598 defaultBufferSource = bufferSource instanceof class_4597.class_4598 ? (bufferSource2 = (class_4597.class_4598)bufferSource) : class_310.method_1551().field_1769.field_20951.method_23000();
        class_1921 renderType = this.getRenderType((GeoAnimatable)this.animatable, this.getTextureLocation(this.animatable), (class_4597)defaultBufferSource, class_310.method_1551().method_1488());
        class_4588 buffer = class_918.method_29711((class_4597)bufferSource, (class_1921)renderType, (boolean)true, (this.currentItemStack != null && this.currentItemStack.method_7958() ? 1 : 0) != 0);
        poseStack.method_22903();
        this.defaultRender(poseStack, (GeoAnimatable)this.animatable, (class_4597)defaultBufferSource, renderType, buffer, 0.0f, class_310.method_1551().method_1488(), packedLight);
        defaultBufferSource.method_22993();
        RenderSystem.enableDepthTest();
        class_308.method_24211();
        poseStack.method_22909();
    }

    @Override
    public void actuallyRender(class_4587 poseStack, T animatable, BakedGeoModel model, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (!isReRender) {
            AnimationState<T> animationState = new AnimationState<T>(animatable, 0.0f, 0.0f, partialTick, false);
            long instanceId = this.getInstanceId(animatable);
            GeoModel<Object> currentModel = this.getGeoModel();
            animationState.setData(DataTickets.TICK, ((GeoAnimatable)animatable).getTick(this.currentItemStack));
            animationState.setData(DataTickets.ITEM_RENDER_PERSPECTIVE, this.renderPerspective);
            animationState.setData(DataTickets.ITEMSTACK, this.currentItemStack);
            ((GeoAnimatable)animatable).getAnimatableInstanceCache().getManagerForId(instanceId).setData(DataTickets.ITEM_RENDER_PERSPECTIVE, this.renderPerspective);
            currentModel.addAdditionalStateData(animatable, instanceId, animationState::setData);
            currentModel.handleAnimations(animatable, instanceId, (AnimationState<Object>)animationState);
        }
        this.modelRenderTranslations = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
        GeoRenderer.super.actuallyRender(poseStack, animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @Override
    public void doPostRenderCleanup() {
        this.animatable = null;
        this.currentItemStack = null;
        this.renderPerspective = null;
    }

    @Override
    public void renderRecursively(class_4587 poseStack, T animatable, GeoBone bone, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
            bone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.modelRenderTranslations));
            bone.setLocalSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.itemRenderTranslations));
        }
        GeoRenderer.super.renderRecursively(poseStack, animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupLightingForGuiRender() {
        if (this.useEntityGuiLighting) {
            class_308.method_34742();
        } else {
            class_308.method_24210();
        }
    }

    @Override
    public void updateAnimatedTextureFrame(T animatable) {
        AnimatableTexture.setAndUpdate(this.getTextureLocation(animatable));
    }

    @Override
    public void fireCompileRenderLayersEvent() {
        ((GeoRenderEvent.Item.CompileRenderLayers.Listener)GeoRenderEvent.Item.CompileRenderLayers.EVENT.invoker()).handle(new GeoRenderEvent.Item.CompileRenderLayers(this));
    }

    @Override
    public boolean firePreRenderEvent(class_4587 poseStack, BakedGeoModel model, class_4597 bufferSource, float partialTick, int packedLight) {
        return ((GeoRenderEvent.Item.Pre.Listener)GeoRenderEvent.Item.Pre.EVENT.invoker()).handle(new GeoRenderEvent.Item.Pre(this, poseStack, model, bufferSource, partialTick, packedLight));
    }

    @Override
    public void firePostRenderEvent(class_4587 poseStack, BakedGeoModel model, class_4597 bufferSource, float partialTick, int packedLight) {
        ((GeoRenderEvent.Item.Post.Listener)GeoRenderEvent.Item.Post.EVENT.invoker()).handle(new GeoRenderEvent.Item.Post(this, poseStack, model, bufferSource, partialTick, packedLight));
    }
}

