/*
 * Decompiled with CFR 0.152.
 */
package carpet.script;

import carpet.script.CarpetScriptServer;
import carpet.script.Context;
import carpet.script.Expression;
import carpet.script.LazyValue;
import carpet.script.ScriptHost;
import carpet.script.Tokenizer;
import carpet.script.exception.ExpressionException;
import carpet.script.exception.InternalExpressionException;
import carpet.script.value.FunctionUnpackedArgumentsValue;
import carpet.script.value.ListValue;
import carpet.script.value.Value;
import java.util.ArrayList;
import java.util.List;

public abstract class Fluff {

    public static abstract class AbstractUnaryOperator
    extends AbstractOperator {
        AbstractUnaryOperator(int precedence, boolean leftAssoc) {
            super(precedence, leftAssoc);
        }

        @Override
        public boolean pure() {
            return true;
        }

        @Override
        public boolean transitive() {
            return false;
        }

        @Override
        public LazyValue lazyEval(Context cc, Context.Type type, Expression e, Tokenizer.Token t, LazyValue v1, LazyValue v2) {
            if (v2 != null) {
                throw new ExpressionException(cc, e, t, "Did not expect a second parameter for unary operator");
            }
            return (c, ignoredType) -> {
                try {
                    return this.evalUnary(v1.evalValue(c, Context.Type.NONE));
                }
                catch (RuntimeException exc) {
                    throw Expression.handleCodeException(cc, exc, e, t);
                }
            };
        }

        @Override
        public Value eval(Value v1, Value v2) {
            throw new IllegalStateException("Shouldn't end up here");
        }

        public abstract Value evalUnary(Value var1);
    }

    public static abstract class AbstractOperator
    extends AbstractLazyOperator
    implements IOperator {
        AbstractOperator(int precedence, boolean leftAssoc) {
            super(precedence, leftAssoc);
        }

        @Override
        public boolean pure() {
            return true;
        }

        @Override
        public boolean transitive() {
            return false;
        }

        @Override
        public LazyValue lazyEval(Context cc, Context.Type type, Expression e, Tokenizer.Token t, LazyValue v1, LazyValue v2) {
            return (c, typeIgnored) -> {
                try {
                    return this.eval(v1.evalValue(c, Context.Type.NONE), v2.evalValue(c, Context.Type.NONE));
                }
                catch (RuntimeException exc) {
                    throw Expression.handleCodeException(cc, exc, e, t);
                }
            };
        }
    }

    public static abstract class AbstractLazyOperator
    implements ILazyOperator {
        int precedence;
        boolean leftAssoc;

        AbstractLazyOperator(int precedence, boolean leftAssoc) {
            this.precedence = precedence;
            this.leftAssoc = leftAssoc;
        }

        @Override
        public int getPrecedence() {
            return this.precedence;
        }

        @Override
        public boolean isLeftAssoc() {
            return this.leftAssoc;
        }
    }

    public static abstract class AbstractFunction
    extends AbstractLazyFunction
    implements IFunction {
        AbstractFunction(int numParams, String name) {
            super(numParams, name);
        }

        @Override
        public boolean pure() {
            return true;
        }

        @Override
        public boolean transitive() {
            return false;
        }

        @Override
        public LazyValue lazyEval(final Context cc, Context.Type type, final Expression e, final Tokenizer.Token t, final List<LazyValue> lazyParams) {
            return new LazyValue(){
                private List<Value> params;

                @Override
                public Value evalValue(Context c, Context.Type type) {
                    ILazyFunction.checkInterrupts();
                    try {
                        return this.eval(this.getParams(c));
                    }
                    catch (RuntimeException exc) {
                        throw Expression.handleCodeException(cc, exc, e, t);
                    }
                }

                private List<Value> getParams(Context c) {
                    if (this.params == null) {
                        this.params = this.unpackArgs(lazyParams, c, Context.Type.NONE);
                    } else {
                        CarpetScriptServer.LOG.error("How did we get here 1");
                    }
                    return this.params;
                }
            };
        }
    }

    public static abstract class AbstractLazyFunction
    implements ILazyFunction {
        protected String name;
        int numParams;

        public AbstractLazyFunction(int numParams, String name) {
            this.numParams = numParams;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public int getNumParams() {
            return this.numParams;
        }

        @Override
        public boolean numParamsVaries() {
            return this.numParams < 0;
        }

        public static List<Value> unpackLazy(List<LazyValue> lzargs, Context c, Context.Type contextType) {
            ArrayList<Value> args = new ArrayList<Value>();
            for (LazyValue lv : lzargs) {
                Value arg = lv.evalValue(c, contextType);
                if (arg instanceof FunctionUnpackedArgumentsValue) {
                    args.addAll(((ListValue)arg).getItems());
                    continue;
                }
                args.add(arg);
            }
            return args;
        }

        public List<Value> unpackArgs(List<LazyValue> lzargs, Context c, Context.Type contextType) {
            List<Value> args = AbstractLazyFunction.unpackLazy(lzargs, c, contextType);
            if (!this.numParamsVaries() && this.getNumParams() != args.size()) {
                throw new InternalExpressionException("Function " + this.getName() + " expected " + this.getNumParams() + " parameters, got " + args.size());
            }
            return args;
        }

        public static List<LazyValue> lazify(List<Value> args) {
            ArrayList<LazyValue> lzargs = new ArrayList<LazyValue>(args.size());
            args.forEach(v -> lzargs.add((c, t) -> v));
            return lzargs;
        }
    }

    public static interface IOperator
    extends ILazyOperator {
        public Value eval(Value var1, Value var2);
    }

    public static interface ILazyOperator
    extends EvalNode {
        public int getPrecedence();

        public boolean isLeftAssoc();

        public LazyValue lazyEval(Context var1, Context.Type var2, Expression var3, Tokenizer.Token var4, LazyValue var5, LazyValue var6);
    }

    public static interface IFunction
    extends ILazyFunction {
        public Value eval(List<Value> var1);
    }

    public static interface ILazyFunction
    extends EvalNode {
        public int getNumParams();

        public boolean numParamsVaries();

        public LazyValue lazyEval(Context var1, Context.Type var2, Expression var3, Tokenizer.Token var4, List<LazyValue> var5);

        public static void checkInterrupts() {
            if (ScriptHost.mainThread != Thread.currentThread() && Thread.currentThread().isInterrupted()) {
                throw new InternalExpressionException("Thread interrupted");
            }
        }
    }

    public static interface EvalNode {
        public boolean pure();

        public boolean transitive();

        default public Context.Type staticType(Context.Type outerType) {
            return this.transitive() ? outerType : Context.NONE;
        }
    }

    public static interface UsageProvider {
        public String getUsage();
    }

    @FunctionalInterface
    public static interface SexFunction<A, B, C, D, E, F, R> {
        public R apply(A var1, B var2, C var3, D var4, E var5, F var6);
    }

    @FunctionalInterface
    public static interface QuinnFunction<A, B, C, D, E, R> {
        public R apply(A var1, B var2, C var3, D var4, E var5);
    }

    @FunctionalInterface
    public static interface QuadFunction<A, B, C, D, R> {
        public R apply(A var1, B var2, C var3, D var4);
    }

    @FunctionalInterface
    public static interface TriFunction<A, B, C, R> {
        public R apply(A var1, B var2, C var3);
    }
}

