/*
 * Decompiled with CFR 0.152.
 */
package carpet.logging;

import carpet.CarpetServer;
import carpet.fakes.MinecraftServerInterface;
import carpet.helpers.HopperCounter;
import carpet.helpers.ServerTickRateManager;
import carpet.logging.LoggerRegistry;
import carpet.logging.logHelpers.PacketCounter;
import carpet.utils.Messenger;
import carpet.utils.SpawnReporter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.function.Consumer;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2772;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public class HUDController {
    private static final List<Consumer<MinecraftServer>> HUDListeners = new ArrayList<Consumer<MinecraftServer>>();
    public static final Map<class_3222, List<class_2561>> player_huds = new HashMap<class_3222, List<class_2561>>();
    public static final Map<String, class_2561> scarpet_headers = new HashMap<String, class_2561>();
    public static final Map<String, class_2561> scarpet_footers = new HashMap<String, class_2561>();

    public static void register(Consumer<MinecraftServer> listener) {
        HUDListeners.add(listener);
    }

    public static void resetScarpetHUDs() {
        scarpet_headers.clear();
        scarpet_footers.clear();
    }

    public static void addMessage(class_3222 player, class_2561 hudMessage) {
        if (player == null) {
            return;
        }
        if (!player_huds.containsKey(player)) {
            player_huds.put(player, new ArrayList());
        } else {
            player_huds.get(player).add((class_2561)class_2561.method_43470((String)"\n"));
        }
        player_huds.get(player).add(hudMessage);
    }

    public static void clearPlayer(class_3222 player) {
        class_2772 packet = new class_2772((class_2561)class_2561.method_43470((String)""), (class_2561)class_2561.method_43470((String)""));
        player.field_13987.method_14364((class_2596)packet);
    }

    public static void update_hud(MinecraftServer server, List<class_3222> force) {
        if (server.method_3780() % 20 != 0 && force == null || CarpetServer.minecraft_server == null) {
            return;
        }
        player_huds.clear();
        server.method_3760().method_14571().forEach(p -> {
            class_2561 scarpetFOoter = scarpet_footers.get(p.method_5820());
            if (scarpetFOoter != null) {
                HUDController.addMessage(p, scarpetFOoter);
            }
        });
        if (LoggerRegistry.__tps) {
            LoggerRegistry.getLogger("tps").log(() -> HUDController.send_tps_display(server));
        }
        if (LoggerRegistry.__mobcaps) {
            LoggerRegistry.getLogger("mobcaps").log((option, player) -> {
                class_5321 dim = switch (option) {
                    case "overworld" -> class_1937.field_25179;
                    case "nether" -> class_1937.field_25180;
                    case "end" -> class_1937.field_25181;
                    default -> player.method_37908().method_27983();
                };
                return new class_2561[]{SpawnReporter.printMobcapsForDimension(server.method_3847(dim), false).get(0)};
            });
        }
        if (LoggerRegistry.__counter) {
            LoggerRegistry.getLogger("counter").log(option -> HUDController.send_counter_info(server, option));
        }
        if (LoggerRegistry.__packets) {
            LoggerRegistry.getLogger("packets").log(HUDController::packetCounter);
        }
        HUDListeners.forEach(l -> l.accept(server));
        HashSet<class_3222> targets = new HashSet<class_3222>(player_huds.keySet());
        if (force != null) {
            targets.addAll(force);
        }
        for (class_3222 player2 : targets) {
            class_2772 packet = new class_2772(scarpet_headers.getOrDefault(player2.method_5820(), (class_2561)class_2561.method_43470((String)"")), Messenger.c(player_huds.getOrDefault(player2, List.of()).toArray(new Object[0])));
            player2.field_13987.method_14364((class_2596)packet);
        }
    }

    private static class_2561[] send_tps_display(MinecraftServer server) {
        OptionalDouble averageTPS = Arrays.stream(server.field_4573).average();
        ServerTickRateManager trm = ((MinecraftServerInterface)server).getTickRateManager();
        if (averageTPS.isEmpty()) {
            return new class_2561[]{class_2561.method_43470((String)"No TPS data available")};
        }
        double MSPT = Arrays.stream(server.field_4573).average().getAsDouble() * 1.0E-6;
        double TPS = 1000.0 / Math.max(trm.isInWarpSpeed() ? 0.0 : (double)trm.mspt(), MSPT);
        if (trm.gameIsPaused()) {
            TPS = 0.0;
        }
        String color = Messenger.heatmap_color(MSPT, trm.mspt());
        return new class_2561[]{Messenger.c("g TPS: ", String.format(Locale.US, "%s %.1f", color, TPS), "g  MSPT: ", String.format(Locale.US, "%s %.1f", color, MSPT))};
    }

    private static class_2561[] send_counter_info(MinecraftServer server, String colors) {
        ArrayList<class_2561> res = new ArrayList<class_2561>();
        for (String color : colors.split(",")) {
            HopperCounter counter = HopperCounter.getCounter(color);
            if (counter == null) continue;
            res.addAll(counter.format(server, false, true));
        }
        return res.toArray(new class_2561[0]);
    }

    private static class_2561[] packetCounter() {
        class_2561[] ret = new class_2561[]{Messenger.c("w I/" + PacketCounter.totalIn + " O/" + PacketCounter.totalOut)};
        PacketCounter.reset();
        return ret;
    }
}

