/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.createtweaker.recipe.manager;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.random.Percentaged;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.createtweaker.recipe.fun.DeployerRecipeFunction;
import com.blamejared.createtweaker.recipe.manager.base.IProcessingRecipeManager;
import com.blamejared.createtweaker.recipe.type.CTDeployerApplicationRecipe;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.kinetics.deployer.DeployerApplicationRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import java.util.function.Consumer;
import net.minecraft.class_1860;
import net.minecraft.class_2960;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.create.DeployerApplicationManager")
@Document(value="mods/CreateTweaker/DeployerApplicationManager")
public class DeployerApplicationManager
implements IProcessingRecipeManager<DeployerApplicationRecipe> {
    @ZenCodeType.Method
    public void addRecipe(String name, IIngredient processedItem, IIngredient heldItem, Percentaged<IItemStack>[] outputs, @ZenCodeType.OptionalBoolean boolean keepHeldItem) {
        if (outputs.length > 2) {
            throw new IllegalArgumentException(String.format("Deployer recipe has more outputs (%s) than supported (2)!", outputs.length));
        }
        this.registerRecipe(name, recipeBuilder -> {
            recipeBuilder.require(processedItem.asVanillaIngredient());
            recipeBuilder.require(heldItem.asVanillaIngredient());
            if (keepHeldItem) {
                recipeBuilder.toolNotConsumed();
            }
            for (Percentaged stack : outputs) {
                recipeBuilder.output((float)stack.getPercentage(), ((IItemStack)stack.getData()).getInternal());
            }
        });
    }

    @ZenCodeType.Method
    public void registerRecipe(String name, Consumer<ProcessingRecipeBuilder<DeployerApplicationRecipe>> recipeBuilder, DeployerRecipeFunction function) {
        name = this.fixRecipeName(name);
        class_2960 recipeId = new class_2960("crafttweaker", name);
        ProcessingRecipeBuilder builder = new ProcessingRecipeBuilder(this.getSerializer().getFactory(), recipeId);
        recipeBuilder.accept((ProcessingRecipeBuilder<DeployerApplicationRecipe>)builder);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (class_1860)new CTDeployerApplicationRecipe((ProcessingRecipeBuilder<DeployerApplicationRecipe>)builder, function), ""));
    }

    @Override
    public AllRecipeTypes getCreateRecipeType() {
        return AllRecipeTypes.DEPLOYING;
    }
}

