/*
 * Decompiled with CFR 0.152.
 */
package gravity_changer.mixin.client;

import gravity_changer.EntityTags;
import gravity_changer.RotationAnimation;
import gravity_changer.api.GravityChangerAPI;
import gravity_changer.util.RotationUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1676;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4538;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_898;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_898.class})
public abstract class EntityRenderDispatcherMixin {
    @Shadow
    @Final
    private static class_1921 field_21009;
    @Shadow
    private boolean field_4681;

    @Shadow
    private static void method_23162(class_4587.class_4665 entry, class_4588 vertices, float alpha, float x, float y, float z, float u, float v) {
    }

    @Inject(method={"Lnet/minecraft/client/renderer/entity/EntityRenderDispatcher;render(Lnet/minecraft/world/entity/Entity;DDDFFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;translate(DDD)V", ordinal=0, shift=At.Shift.AFTER)})
    private void inject_render_0(class_1297 entity, double x, double y, double z, float yaw, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, CallbackInfo ci) {
        if (!(entity instanceof class_1676) && !(entity instanceof class_1303) && EntityTags.allowGravityTransformationInRendering(entity)) {
            class_2350 gravityDirection = GravityChangerAPI.getGravityDirection(entity);
            if (!this.field_4681) {
                return;
            }
            matrices.method_22903();
            RotationAnimation animation = GravityChangerAPI.getRotationAnimation(entity);
            if (animation == null) {
                return;
            }
            long timeMs = entity.method_37908().method_8510() * 50L + (long)(tickDelta * 50.0f);
            matrices.method_22907(new Quaternionf((Quaternionfc)animation.getCurrentGravityRotation(gravityDirection, timeMs)).conjugate());
        }
    }

    @Inject(method={"Lnet/minecraft/client/renderer/entity/EntityRenderDispatcher;render(Lnet/minecraft/world/entity/Entity;DDDFFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;translate(DDD)V", ordinal=1)})
    private void inject_render_1(class_1297 entity, double x, double y, double z, float yaw, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, CallbackInfo ci) {
        if (!(entity instanceof class_1676) && !(entity instanceof class_1303) && EntityTags.allowGravityTransformationInRendering(entity)) {
            class_2350 gravityDirection = GravityChangerAPI.getGravityDirection(entity);
            if (!this.field_4681) {
                return;
            }
            matrices.method_22909();
        }
    }

    @Inject(method={"Lnet/minecraft/client/renderer/entity/EntityRenderDispatcher;render(Lnet/minecraft/world/entity/Entity;DDDFFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;translate(DDD)V", ordinal=1, shift=At.Shift.AFTER)})
    private void inject_render_2(class_1297 entity, double x, double y, double z, float yaw, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, CallbackInfo ci) {
        if (!(entity instanceof class_1676) && !(entity instanceof class_1303) && EntityTags.allowGravityTransformationInRendering(entity)) {
            class_2350 gravityDirection = GravityChangerAPI.getGravityDirection(entity);
            if (gravityDirection == class_2350.field_11033) {
                return;
            }
            if (!this.field_4681) {
                return;
            }
            matrices.method_22907(RotationUtil.getCameraRotationQuaternion(gravityDirection));
        }
    }

    @Inject(method={"Lnet/minecraft/client/renderer/entity/EntityRenderDispatcher;renderShadow(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;Lnet/minecraft/world/entity/Entity;FFLnet/minecraft/world/level/LevelReader;F)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void inject_renderShadow(class_4587 matrices, class_4597 vertexConsumers, class_1297 entity, float opacity, float tickDelta, class_4538 world, float radius, CallbackInfo ci) {
        class_2350 gravityDirection = GravityChangerAPI.getGravityDirection(entity);
        if (gravityDirection == class_2350.field_11033) {
            return;
        }
        ci.cancel();
        double x = class_3532.method_16436((double)tickDelta, (double)entity.field_6038, (double)entity.method_23317());
        double y = class_3532.method_16436((double)tickDelta, (double)entity.field_5971, (double)entity.method_23318());
        double z = class_3532.method_16436((double)tickDelta, (double)entity.field_5989, (double)entity.method_23321());
        class_243 minShadowPos = RotationUtil.vecPlayerToWorld((double)(-radius), (double)(-radius), (double)(-radius), gravityDirection).method_1031(x, y, z);
        class_243 maxShadowPos = RotationUtil.vecPlayerToWorld((double)radius, 0.0, (double)radius, gravityDirection).method_1031(x, y, z);
        class_4587.class_4665 entry = matrices.method_23760();
        class_4588 vertexConsumer = vertexConsumers.getBuffer(field_21009);
        for (class_2338 blockPos : class_2338.method_10097((class_2338)class_2338.method_49638((class_2374)minShadowPos), (class_2338)class_2338.method_49638((class_2374)maxShadowPos))) {
            EntityRenderDispatcherMixin.gravitychanger$renderShadowPartPlayer(entry, vertexConsumer, world, blockPos, x, y, z, radius, opacity, gravityDirection);
        }
    }

    private static void gravitychanger$renderShadowPartPlayer(class_4587.class_4665 entry, class_4588 vertices, class_4538 world, class_2338 pos, double x, double y, double z, float radius, float opacity, class_2350 gravityDirection) {
        class_265 voxelShape;
        class_2338 posBelow = pos.method_10093(gravityDirection);
        class_2680 blockStateBelow = world.method_8320(posBelow);
        if (blockStateBelow.method_26217() != class_2464.field_11455 && world.method_22339(pos) > 3 && blockStateBelow.method_26234((class_1922)world, posBelow) && !(voxelShape = blockStateBelow.method_26218((class_1922)world, posBelow)).method_1110()) {
            class_243 playerPos = RotationUtil.vecWorldToPlayer(x, y, z, gravityDirection);
            float alpha = (float)(((double)opacity - (playerPos.field_1351 - (RotationUtil.vecWorldToPlayer((class_243)class_243.method_24953((class_2382)pos), (class_2350)gravityDirection).field_1351 - 0.5)) / 2.0) * 0.5 * (double)world.method_22349(pos));
            if (alpha >= 0.0f) {
                if (alpha > 1.0f) {
                    alpha = 1.0f;
                }
                class_243 centerPos = class_243.method_24953((class_2382)pos);
                class_243 playerCenterPos = RotationUtil.vecWorldToPlayer(centerPos, gravityDirection);
                class_243 playerRelNN = playerCenterPos.method_1031(-0.5, -0.5, -0.5).method_1020(playerPos);
                class_243 playerRelPP = playerCenterPos.method_1031(0.5, -0.5, 0.5).method_1020(playerPos);
                class_243 relNN = RotationUtil.vecWorldToPlayer(centerPos.method_1019(RotationUtil.vecPlayerToWorld(-0.5, -0.5, -0.5, gravityDirection)).method_1023(x, y, z), gravityDirection);
                class_243 relNP = RotationUtil.vecWorldToPlayer(centerPos.method_1019(RotationUtil.vecPlayerToWorld(-0.5, -0.5, 0.5, gravityDirection)).method_1023(x, y, z), gravityDirection);
                class_243 relPN = RotationUtil.vecWorldToPlayer(centerPos.method_1019(RotationUtil.vecPlayerToWorld(0.5, -0.5, -0.5, gravityDirection)).method_1023(x, y, z), gravityDirection);
                class_243 relPP = RotationUtil.vecWorldToPlayer(centerPos.method_1019(RotationUtil.vecPlayerToWorld(0.5, -0.5, 0.5, gravityDirection)).method_1023(x, y, z), gravityDirection);
                float minU = -((float)playerRelNN.field_1352) / 2.0f / radius + 0.5f;
                float maxU = -((float)playerRelPP.field_1352) / 2.0f / radius + 0.5f;
                float minV = -((float)playerRelNN.field_1350) / 2.0f / radius + 0.5f;
                float maxV = -((float)playerRelPP.field_1350) / 2.0f / radius + 0.5f;
                EntityRenderDispatcherMixin.method_23162(entry, vertices, alpha, (float)relNN.field_1352, (float)relNN.field_1351, (float)relNN.field_1350, minU, minV);
                EntityRenderDispatcherMixin.method_23162(entry, vertices, alpha, (float)relNP.field_1352, (float)relNP.field_1351, (float)relNP.field_1350, minU, maxV);
                EntityRenderDispatcherMixin.method_23162(entry, vertices, alpha, (float)relPP.field_1352, (float)relPP.field_1351, (float)relPP.field_1350, maxU, maxV);
                EntityRenderDispatcherMixin.method_23162(entry, vertices, alpha, (float)relPN.field_1352, (float)relPN.field_1351, (float)relPN.field_1350, maxU, minV);
            }
        }
    }

    @ModifyVariable(method={"Lnet/minecraft/client/renderer/entity/EntityRenderDispatcher;renderHitbox(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/world/entity/Entity;F)V"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/phys/AABB;move(DDD)Lnet/minecraft/world/phys/AABB;", ordinal=0), ordinal=0)
    private static class_238 modify_renderHitbox_Box_0(class_238 box, class_4587 matrices, class_4588 vertices, class_1297 entity, float tickDelta) {
        class_2350 gravityDirection = GravityChangerAPI.getGravityDirection(entity);
        if (gravityDirection == class_2350.field_11033) {
            return box;
        }
        return RotationUtil.boxWorldToPlayer(box, gravityDirection);
    }

    @Redirect(method={"Lnet/minecraft/client/renderer/entity/EntityRenderDispatcher;renderHitbox(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/world/entity/Entity;F)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getViewVector(F)Lnet/minecraft/world/phys/Vec3;", ordinal=0))
    private static class_243 redirectViewVector(class_1297 instance, float partialTicks) {
        class_243 viewVector = instance.method_5828(partialTicks);
        class_2350 gravityDirection = GravityChangerAPI.getGravityDirection(instance);
        if (gravityDirection == class_2350.field_11033) {
            return viewVector;
        }
        return RotationUtil.vecWorldToPlayer(viewVector, gravityDirection);
    }
}

