/*
 * Decompiled with CFR 0.152.
 */
package gravity_changer.mixin.client;

import com.mojang.authlib.GameProfile;
import gravity_changer.api.GravityChangerAPI;
import gravity_changer.util.RotationUtil;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_746.class})
public abstract class ClientPlayerEntityMixin
extends class_742 {
    public ClientPlayerEntityMixin(class_638 world, GameProfile profile) {
        super(world, profile);
    }

    @Shadow
    protected abstract boolean method_30674(class_2338 var1);

    @Redirect(method={"Lnet/minecraft/client/player/LocalPlayer;suffocatesAt(Lnet/minecraft/core/BlockPos;)Z"}, at=@At(value="NEW", target="(DDDDDD)Lnet/minecraft/world/phys/AABB;", ordinal=0))
    private class_238 redirect_wouldCollideAt_new_0(double x1, double y1, double z1, double x2, double y2, double z2, class_2338 pos) {
        class_2350 gravityDirection = GravityChangerAPI.getGravityDirection((class_1297)this);
        if (gravityDirection == class_2350.field_11033) {
            return new class_238(x1, y1, z1, x2, y2, z2);
        }
        class_238 playerBox = this.method_5829();
        class_243 playerMask = RotationUtil.maskPlayerToWorld(0.0, 1.0, 0.0, gravityDirection);
        class_238 posBox = new class_238(pos);
        class_243 posMask = RotationUtil.maskPlayerToWorld(1.0, 0.0, 1.0, gravityDirection);
        return new class_238(playerMask.method_18805(playerBox.field_1323, playerBox.field_1322, playerBox.field_1321).method_1019(posMask.method_18805(posBox.field_1323, posBox.field_1322, posBox.field_1321)), playerMask.method_18805(playerBox.field_1320, playerBox.field_1325, playerBox.field_1324).method_1019(posMask.method_18805(posBox.field_1320, posBox.field_1325, posBox.field_1324)));
    }

    @Inject(method={"Lnet/minecraft/client/player/LocalPlayer;moveTowardsClosestSpace(DD)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject_pushOutOfBlocks(double x, double z, CallbackInfo ci) {
        class_2350 gravityDirection = GravityChangerAPI.getGravityDirection((class_1297)this);
        if (gravityDirection == class_2350.field_11033) {
            return;
        }
        ci.cancel();
        class_243 pos = RotationUtil.vecPlayerToWorld(x - this.method_23317(), 0.0, z - this.method_23321(), gravityDirection).method_1019(this.method_19538());
        class_2338 blockPos = class_2338.method_49638((class_2374)pos);
        if (this.method_30674(blockPos)) {
            class_2350[] directions;
            double dx = pos.field_1352 - (double)blockPos.method_10263();
            double dy = pos.field_1351 - (double)blockPos.method_10264();
            double dz = pos.field_1350 - (double)blockPos.method_10260();
            class_2350 direction = null;
            double minDistToEdge = Double.MAX_VALUE;
            for (class_2350 playerDirection : directions = new class_2350[]{class_2350.field_11039, class_2350.field_11034, class_2350.field_11043, class_2350.field_11035}) {
                double distToEdge;
                class_2350 worldDirection = RotationUtil.dirPlayerToWorld(playerDirection, gravityDirection);
                double g = worldDirection.method_10166().method_10172(dx, dy, dz);
                double d = distToEdge = worldDirection.method_10171() == class_2350.class_2352.field_11056 ? 1.0 - g : g;
                if (!(distToEdge < minDistToEdge) || this.method_30674(blockPos.method_10093(worldDirection))) continue;
                minDistToEdge = distToEdge;
                direction = playerDirection;
            }
            if (direction != null) {
                class_243 velocity = this.method_18798();
                if (direction.method_10166() == class_2350.class_2351.field_11048) {
                    this.method_18800(0.1 * (double)direction.method_10148(), velocity.field_1351, velocity.field_1350);
                } else if (direction.method_10166() == class_2350.class_2351.field_11051) {
                    this.method_18800(velocity.field_1352, velocity.field_1351, 0.1 * (double)direction.method_10165());
                }
            }
        }
    }
}

