/*
 * Decompiled with CFR 0.152.
 */
package gravity_changer.mixin.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import gravity_changer.RotationAnimation;
import gravity_changer.api.GravityChangerAPI;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_4184.class}, priority=1001)
public abstract class CameraMixin {
    @Shadow
    private class_1297 field_18711;
    @Shadow
    @Final
    private Quaternionf field_21518;
    @Shadow
    private float field_18722;
    @Shadow
    private float field_18721;

    @Shadow
    protected abstract void method_19327(double var1, double var3, double var5);

    @WrapOperation(method={"setup"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Camera;setPosition(DDD)V", ordinal=0)})
    private void wrapOperation_update_setPos_0(class_4184 camera, double x, double y, double z, Operation<Void> original, class_1922 area, class_1297 focusedEntity, boolean thirdPerson, boolean inverseView, float tickDelta) {
        class_2350 gravityDirection = GravityChangerAPI.getGravityDirection(focusedEntity);
        RotationAnimation animation = GravityChangerAPI.getRotationAnimation(focusedEntity);
        if (animation == null) {
            original.call(new Object[]{this, x, y, z});
            return;
        }
        float partialTick = class_310.method_1551().method_1488();
        long timeMs = focusedEntity.method_37908().method_8510() * 50L + (long)(partialTick * 50.0f);
        animation.update(timeMs);
        if (gravityDirection == class_2350.field_11033 && !animation.isInAnimation()) {
            original.call(new Object[]{this, x, y, z});
            return;
        }
        Quaternionf gravityRotation = animation.getCurrentGravityRotation(gravityDirection, timeMs);
        double entityX = class_3532.method_16436((double)tickDelta, (double)focusedEntity.field_6014, (double)focusedEntity.method_23317());
        double entityY = class_3532.method_16436((double)tickDelta, (double)focusedEntity.field_6036, (double)focusedEntity.method_23318());
        double entityZ = class_3532.method_16436((double)tickDelta, (double)focusedEntity.field_5969, (double)focusedEntity.method_23321());
        double currentCameraY = class_3532.method_16439((float)tickDelta, (float)this.field_18722, (float)this.field_18721);
        class_243 eyeOffset = animation.getEyeOffset(gravityRotation, new class_243(0.0, currentCameraY, 0.0), gravityDirection);
        original.call(new Object[]{this, entityX + eyeOffset.method_10216(), entityY + eyeOffset.method_10214(), entityZ + eyeOffset.method_10215()});
    }

    @Inject(method={"Lnet/minecraft/client/Camera;setRotation(FF)V"}, at={@At(value="INVOKE", target="Lorg/joml/Quaternionf;rotationYXZ(FFF)Lorg/joml/Quaternionf;", shift=At.Shift.AFTER, remap=false)})
    private void inject_setRotation(CallbackInfo ci) {
        if (this.field_18711 != null) {
            class_2350 gravityDirection = GravityChangerAPI.getGravityDirection(this.field_18711);
            RotationAnimation animation = GravityChangerAPI.getRotationAnimation(this.field_18711);
            if (animation == null) {
                return;
            }
            if (gravityDirection == class_2350.field_11033 && !animation.isInAnimation()) {
                return;
            }
            float partialTick = class_310.method_1551().method_1488();
            long timeMs = this.field_18711.method_37908().method_8510() * 50L + (long)(partialTick * 50.0f);
            Quaternionf rotation = new Quaternionf((Quaternionfc)animation.getCurrentGravityRotation(gravityDirection, timeMs));
            rotation.conjugate();
            rotation.mul((Quaternionfc)this.field_21518);
            this.field_21518.set(rotation.x(), rotation.y(), rotation.z(), rotation.w());
        }
    }
}

