/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.gui;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.config.ConfigType;
import fi.dy.masa.malilib.config.ConfigUtils;
import fi.dy.masa.malilib.config.IConfigBoolean;
import fi.dy.masa.malilib.config.options.BooleanHotkeyGuiWrapper;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiConfigsBase;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.widgets.WidgetListConfigOptions;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.config.StructureToggle;
import fi.dy.masa.minihud.gui.GuiShapeManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_437;

public class GuiConfigs
extends GuiConfigsBase {
    public static ImmutableList<RendererToggle> RENDERER_LIST = RendererToggle.VALUES;
    public static ImmutableList<InfoToggle> INFO_LINE_LIST = InfoToggle.VALUES;
    public static ConfigGuiTab tab = ConfigGuiTab.INFO_LINES;

    public GuiConfigs() {
        super(10, 50, "minihud", null, "minihud.gui.title.configs", new Object[0]);
    }

    public void initGui() {
        if (tab == ConfigGuiTab.SHAPES) {
            GuiBase.openGui((class_437)new GuiShapeManager());
            return;
        }
        super.initGui();
        this.clearOptions();
        int x = 10;
        int y = 26;
        int rows = 1;
        for (ConfigGuiTab tab : ConfigGuiTab.values()) {
            int width = this.getStringWidth(tab.getDisplayName()) + 10;
            if (x >= this.field_22789 - width - 10) {
                x = 10;
                y += 22;
                ++rows;
            }
            x += this.createButton(x, y, width, tab);
        }
        if (rows > 1) {
            int scrollbarPosition = ((WidgetListConfigOptions)this.getListWidget()).getScrollbar().getValue();
            this.setListPosition(this.getListX(), 50 + (rows - 1) * 22);
            this.reCreateListWidget();
            ((WidgetListConfigOptions)this.getListWidget()).getScrollbar().setValue(scrollbarPosition);
            ((WidgetListConfigOptions)this.getListWidget()).refreshEntries();
        }
    }

    private int createButton(int x, int y, int width, ConfigGuiTab tab) {
        ButtonGeneric button = new ButtonGeneric(x, y, width, 20, tab.getDisplayName(), new String[0]);
        button.setEnabled(GuiConfigs.tab != tab);
        this.addButton((ButtonBase)button, new ButtonListenerConfigTabs(tab, this));
        return button.getWidth() + 2;
    }

    protected int getConfigWidth() {
        ConfigGuiTab tab = GuiConfigs.tab;
        if (tab == ConfigGuiTab.GENERIC) {
            return 200;
        }
        if (tab == ConfigGuiTab.INFO_LINES || tab == ConfigGuiTab.STRUCTURES || tab == ConfigGuiTab.RENDERERS) {
            return 260;
        }
        if (tab == ConfigGuiTab.COLORS) {
            return 100;
        }
        return super.getConfigWidth();
    }

    protected boolean useKeybindSearch() {
        return tab != ConfigGuiTab.COLORS;
    }

    public List<GuiConfigsBase.ConfigOptionWrapper> getConfigs() {
        ConfigGuiTab tab = GuiConfigs.tab;
        if (tab == ConfigGuiTab.GENERIC) {
            return GuiConfigsBase.ConfigOptionWrapper.createFor(Configs.Generic.OPTIONS);
        }
        if (tab == ConfigGuiTab.COLORS) {
            return GuiConfigsBase.ConfigOptionWrapper.createFor(Configs.Colors.OPTIONS);
        }
        if (tab == ConfigGuiTab.INFO_LINES) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(Configs.Generic.MAIN_RENDERING_TOGGLE);
            list.addAll(INFO_LINE_LIST.stream().map(this::wrapConfig).toList());
            list.addAll(ConfigUtils.createConfigWrapperForType((ConfigType)ConfigType.INTEGER, INFO_LINE_LIST));
            return GuiConfigsBase.ConfigOptionWrapper.createFor(list);
        }
        if (tab == ConfigGuiTab.STRUCTURES) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(Configs.Generic.MAIN_RENDERING_TOGGLE);
            list.add(this.wrapConfig(RendererToggle.OVERLAY_STRUCTURE_MAIN_TOGGLE));
            list.addAll(StructureToggle.VALUES.stream().map(this::wrapConfig).toList());
            list.addAll((Collection<Object>)StructureToggle.COLOR_CONFIGS);
            return GuiConfigsBase.ConfigOptionWrapper.createFor(list);
        }
        if (tab == ConfigGuiTab.RENDERERS) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(Configs.Generic.MAIN_RENDERING_TOGGLE);
            list.addAll(RENDERER_LIST.stream().map(this::wrapConfig).toList());
            return GuiConfigsBase.ConfigOptionWrapper.createFor(list);
        }
        return Collections.emptyList();
    }

    protected BooleanHotkeyGuiWrapper wrapConfig(InfoToggle config) {
        return new BooleanHotkeyGuiWrapper(config.getName(), (IConfigBoolean)config, config.getKeybind());
    }

    protected BooleanHotkeyGuiWrapper wrapConfig(RendererToggle config) {
        return new BooleanHotkeyGuiWrapper(config.getName(), (IConfigBoolean)config, config.getKeybind());
    }

    protected BooleanHotkeyGuiWrapper wrapConfig(StructureToggle config) {
        return new BooleanHotkeyGuiWrapper(config.getToggleOption().getName(), config.getToggleOption(), config.getHotkey().getKeybind());
    }

    public static enum ConfigGuiTab {
        GENERIC("minihud.gui.button.config_gui.generic"),
        COLORS("minihud.gui.button.config_gui.colors"),
        INFO_LINES("minihud.gui.button.config_gui.info_lines"),
        STRUCTURES("minihud.gui.button.config_gui.structures"),
        RENDERERS("minihud.gui.button.config_gui.renderers"),
        SHAPES("minihud.gui.button.config_gui.shapes");

        private final String translationKey;

        private ConfigGuiTab(String translationKey) {
            this.translationKey = translationKey;
        }

        public String getDisplayName() {
            return StringUtils.translate((String)this.translationKey, (Object[])new Object[0]);
        }
    }

    private static class ButtonListenerConfigTabs
    implements IButtonActionListener {
        private final GuiConfigs parent;
        private final ConfigGuiTab tab;

        public ButtonListenerConfigTabs(ConfigGuiTab tab, GuiConfigs parent) {
            this.tab = tab;
            this.parent = parent;
        }

        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            tab = this.tab;
            if (this.tab == ConfigGuiTab.SHAPES) {
                GuiBase.openGui((class_437)new GuiShapeManager());
            } else {
                this.parent.reCreateListWidget();
                ((WidgetListConfigOptions)this.parent.getListWidget()).resetScrollbarPosition();
                this.parent.initGui();
            }
        }
    }
}

