/*
 * Decompiled with CFR 0.152.
 */
package modpackChecker;

import modpackChecker.ConfigManager;
import modpackChecker.ModpackChecker;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerLoginConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerLoginNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class NetworkHandler {
    public static final class_2960 VERSION_CHECK_CHANNEL = new class_2960("modpack-checker", "version_check");

    public static void register() {
        ModpackChecker.LOGGER.info("Registering network handlers");
        NetworkHandler.registerVersionHandler();
    }

    private static String[] parseConnectionInfo(String conInfo) {
        try {
            int uuidIndex;
            String name = "Unknown";
            String uuid = "Unknown";
            int nameIndex = conInfo.indexOf("name=");
            if (nameIndex != -1) {
                int nameStart = nameIndex + 5;
                int nameEnd = conInfo.indexOf(",", nameStart);
                if (nameEnd == -1) {
                    nameEnd = conInfo.length();
                }
                if (nameStart < nameEnd && nameEnd <= conInfo.length()) {
                    name = conInfo.substring(nameStart, nameEnd);
                }
            }
            if ((uuidIndex = conInfo.indexOf("id=")) != -1) {
                int uuidStart = uuidIndex + 3;
                int uuidEnd = conInfo.indexOf(",", uuidStart);
                if (uuidEnd == -1) {
                    uuidEnd = conInfo.length();
                }
                if (uuidStart < uuidEnd && uuidEnd <= conInfo.length()) {
                    uuid = conInfo.substring(uuidStart, uuidEnd);
                }
            }
            return new String[]{name, uuid};
        }
        catch (Exception e) {
            ModpackChecker.LOGGER.warn("Failed to parse connection info: {}", (Object)conInfo, (Object)e);
            return new String[]{"Unknown", "Unknown"};
        }
    }

    private static void registerVersionHandler() {
        ServerLoginConnectionEvents.QUERY_START.register((handler, server, sender, synchronizer) -> {
            if (ConfigManager.enable) {
                String conInfo = handler.method_14383();
                String[] playerInfo = NetworkHandler.parseConnectionInfo(conInfo);
                String name = playerInfo[0];
                String uuid = playerInfo[1];
                class_2540 buf = PacketByteBufs.create();
                sender.sendPacket(VERSION_CHECK_CHANNEL, buf);
                ModpackChecker.LOGGER.debug("Sending version request to {}: {}", (Object)name, (Object)uuid);
            } else {
                ModpackChecker.LOGGER.debug("Modpack checking is disabled, skipping version check");
            }
        });
        ServerLoginNetworking.registerGlobalReceiver((class_2960)VERSION_CHECK_CHANNEL, (server, handler, understood, buf, synchronizer, responseSender) -> {
            if (!ConfigManager.enable) {
                ModpackChecker.LOGGER.debug("Modpack checking is disabled, allowing connection");
                return;
            }
            if (!understood) {
                String conInfo = handler.method_14383();
                String[] playerInfo = NetworkHandler.parseConnectionInfo(conInfo);
                String name = playerInfo[0];
                ModpackChecker.LOGGER.debug("Client {} doesn't have the mod installed, disconnecting", (Object)name);
                handler.method_14380(class_2561.method_30163((String)ConfigManager.noModMessage));
            } else {
                try {
                    String clientVersion = buf.method_10800(64);
                    String conInfo = handler.method_14383();
                    String[] playerInfo = NetworkHandler.parseConnectionInfo(conInfo);
                    String name = playerInfo[0];
                    String uuid = playerInfo[1];
                    if (!ConfigManager.areVersionsCompatible(clientVersion, ConfigManager.expectedVersion)) {
                        String message = ConfigManager.formatMessage(ConfigManager.wrongVersionMessage, ConfigManager.expectedVersion);
                        ModpackChecker.LOGGER.debug("Client {} has incompatible version: {} (expected: {}), disconnecting", new Object[]{name, clientVersion, ConfigManager.expectedVersion});
                        handler.method_14380(class_2561.method_30163((String)message));
                    } else {
                        ModpackChecker.LOGGER.debug("Version verified for {}: {} (version: {})", new Object[]{name, uuid, clientVersion});
                    }
                }
                catch (Exception e) {
                    ModpackChecker.LOGGER.error("Failed to process version check", (Throwable)e);
                    String conInfo = handler.method_14383();
                    String[] playerInfo = NetworkHandler.parseConnectionInfo(conInfo);
                    String name = playerInfo[0];
                    ModpackChecker.LOGGER.debug("Version check failed for {}, disconnecting", (Object)name);
                    handler.method_14380(class_2561.method_30163((String)ConfigManager.serverErrorMessage));
                }
            }
        });
    }
}

