/*
 * Decompiled with CFR 0.152.
 */
package modpackChecker;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import modpackChecker.ModpackChecker;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigManager {
    private static final String DEFAULT_VERSION = "1.0.0";
    private static final String DEV_VERSION = "0.0.0";
    private static final Path CONFIG_DIR = FabricLoader.getInstance().getGameDir().resolve("config");
    private static final Path SERVER_CONFIG_PATH = CONFIG_DIR.resolve("modpack-checker-server.toml");
    private static final Path CLIENT_CONFIG_PATH = CONFIG_DIR.resolve("modpack-checker-client.toml");
    private static boolean isClientEnvironment = false;
    public static boolean enable = true;
    public static String expectedVersion = "1.0.0";
    public static String noModMessage = "Please install the Modpack: <your-modpack-link>";
    public static String wrongVersionMessage = "Please install modpack version {version}: <your-modpack-link+version>";
    public static String serverErrorMessage = "Server configuration error. Please contact an administrator.";
    public static String clientVersion = "0.0.0";

    public static void init(boolean isClient) {
        isClientEnvironment = isClient;
        try {
            if (!Files.exists(CONFIG_DIR, new LinkOption[0])) {
                Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            }
            ConfigManager.copyDefaultConfigs();
            if (isClientEnvironment) {
                ConfigManager.loadClientConfig();
                ModpackChecker.LOGGER.debug("Client configuration loaded successfully");
            } else {
                ConfigManager.loadServerConfig();
                ModpackChecker.LOGGER.debug("Server configuration loaded successfully");
            }
        }
        catch (IOException e) {
            ModpackChecker.LOGGER.error("Failed to initialize configuration", (Throwable)e);
        }
    }

    public static void reload() {
        try {
            if (isClientEnvironment) {
                ConfigManager.loadClientConfig();
                ModpackChecker.LOGGER.debug("Client configuration reloaded successfully");
            } else {
                ConfigManager.loadServerConfig();
                ModpackChecker.LOGGER.debug("Server configuration reloaded successfully");
            }
        }
        catch (IOException e) {
            ModpackChecker.LOGGER.error("Failed to reload configuration", (Throwable)e);
        }
    }

    private static void copyDefaultConfigs() throws IOException {
        if (isClientEnvironment) {
            if (!Files.exists(CLIENT_CONFIG_PATH, new LinkOption[0])) {
                String defaultClientConfig = "# Modpack Checker Client Configuration\n\n# Current modpack version - this should match the server's expected version\n# Use \"0.0.0\" for development (always allows joining)\nversion = \"%s\"\n".formatted(DEV_VERSION);
                Files.writeString(CLIENT_CONFIG_PATH, (CharSequence)defaultClientConfig, new OpenOption[0]);
                ModpackChecker.LOGGER.info("Created default client configuration file");
            }
        } else if (!Files.exists(SERVER_CONFIG_PATH, new LinkOption[0])) {
            String defaultServerConfig = "# Modpack Checker Server Configuration\n\n# Enable or disable modpack version checking\nenable = true\n\n# Expected modpack version that clients must have\nexpected_version = \"%s\"\n\n# Kick messages for different scenarios\n[messages]\n# Message shown when client doesn't have the mod installed\nno_mod = \"Please install the ModpackChecker mod: https://triibu.tech/minecraft\"\n\n# Message shown when client has wrong version (use {version} as placeholder)\nwrong_version = \"Please install modpack version {version}: https://triibu.tech/minecraft\"\n\n# Message shown when there's a server configuration error\nserver_error = \"Server configuration error. Please contact an administrator.\"\n".formatted(DEFAULT_VERSION);
            Files.writeString(SERVER_CONFIG_PATH, (CharSequence)defaultServerConfig, new OpenOption[0]);
            ModpackChecker.LOGGER.info("Created default server configuration file");
        }
    }

    private static void loadServerConfig() throws IOException {
        if (!Files.exists(SERVER_CONFIG_PATH, new LinkOption[0])) {
            ModpackChecker.LOGGER.warn("Server configuration file not found, using defaults");
            return;
        }
        try (FileConfig config = FileConfig.of((Path)SERVER_CONFIG_PATH, (ConfigFormat)TomlFormat.instance());){
            config.load();
            enable = (Boolean)config.getOrElse("enable", (Object)true);
            expectedVersion = (String)config.getOrElse("expected_version", (Object)DEFAULT_VERSION);
            Config messages = (Config)config.get("messages");
            if (messages != null) {
                noModMessage = (String)messages.getOrElse("no_mod", (Object)noModMessage);
                wrongVersionMessage = (String)messages.getOrElse("wrong_version", (Object)wrongVersionMessage);
                serverErrorMessage = (String)messages.getOrElse("server_error", (Object)serverErrorMessage);
            }
            ModpackChecker.LOGGER.info("Server configuration loaded - enable: {}, expected version: {}", (Object)enable, (Object)expectedVersion);
        }
        catch (Exception e) {
            ModpackChecker.LOGGER.error("Failed to load server configuration", (Throwable)e);
        }
    }

    private static void loadClientConfig() throws IOException {
        if (!Files.exists(CLIENT_CONFIG_PATH, new LinkOption[0])) {
            ModpackChecker.LOGGER.warn("Client configuration file not found, using defaults");
            return;
        }
        try (FileConfig config = FileConfig.of((Path)CLIENT_CONFIG_PATH, (ConfigFormat)TomlFormat.instance());){
            config.load();
            clientVersion = (String)config.getOrElse("version", (Object)DEFAULT_VERSION);
            ModpackChecker.LOGGER.info("Client configuration loaded - version: {}", (Object)clientVersion);
        }
        catch (Exception e) {
            ModpackChecker.LOGGER.error("Failed to load client configuration", (Throwable)e);
        }
    }

    public static String formatMessage(String message, String version) {
        return message.replace("{version}", version);
    }

    public static boolean isDevVersion(String version) {
        return DEV_VERSION.equals(version);
    }

    public static boolean areVersionsCompatible(String clientVersion, String serverVersion) {
        return clientVersion.equals(serverVersion) || ConfigManager.isDevVersion(clientVersion);
    }
}

