/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.computer;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;

public final class ComputerEvents {
    private ComputerEvents() {
    }

    public static void keyDown(Receiver receiver, int key, boolean repeat) {
        receiver.queueEvent("key", new Object[]{key, repeat});
    }

    public static void keyUp(Receiver receiver, int key) {
        receiver.queueEvent("key_up", new Object[]{key});
    }

    public static void charTyped(Receiver receiver, byte chr) {
        receiver.queueEvent("char", new Object[]{new byte[]{chr}});
    }

    public static void paste(Receiver receiver, ByteBuffer contents) {
        receiver.queueEvent("paste", new Object[]{contents});
    }

    public static void mouseClick(Receiver receiver, int button, int x, int y) {
        receiver.queueEvent("mouse_click", new Object[]{button, x, y});
    }

    public static void mouseUp(Receiver receiver, int button, int x, int y) {
        receiver.queueEvent("mouse_up", new Object[]{button, x, y});
    }

    public static void mouseDrag(Receiver receiver, int button, int x, int y) {
        receiver.queueEvent("mouse_drag", new Object[]{button, x, y});
    }

    public static void mouseScroll(Receiver receiver, int direction, int x, int y) {
        receiver.queueEvent("mouse_scroll", new Object[]{direction, x, y});
    }

    @FunctionalInterface
    public static interface Receiver {
        public void queueEvent(String var1, @Nullable Object @Nullable [] var2);
    }
}

