/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client;

import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.client.FrameInfo;
import dan200.computercraft.client.pocket.ClientPocketComputers;
import dan200.computercraft.client.render.CableHighlightRenderer;
import dan200.computercraft.client.render.PocketItemRenderer;
import dan200.computercraft.client.render.PrintoutItemRenderer;
import dan200.computercraft.client.render.monitor.MonitorBlockEntityRenderer;
import dan200.computercraft.client.render.monitor.MonitorHighlightRenderer;
import dan200.computercraft.client.render.monitor.MonitorRenderState;
import dan200.computercraft.client.sound.SpeakerManager;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.media.items.PrintoutItem;
import dan200.computercraft.shared.peripheral.modem.wired.CableBlock;
import dan200.computercraft.shared.peripheral.modem.wired.CableModemVariant;
import dan200.computercraft.shared.peripheral.modem.wired.CableShapes;
import dan200.computercraft.shared.peripheral.monitor.MonitorBlockEntity;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import dan200.computercraft.shared.turtle.blocks.TurtleBlockEntity;
import dan200.computercraft.shared.util.PauseAwareTimer;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1140;
import net.minecraft.class_1268;
import net.minecraft.class_1533;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4224;
import net.minecraft.class_4234;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.jspecify.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class ClientHooks {
    private ClientHooks() {
    }

    public static void onTick() {
        FrameInfo.onTick();
    }

    public static void onRenderTick() {
        PauseAwareTimer.tick(class_310.method_1551().method_1493());
        FrameInfo.onRenderTick();
    }

    public static void onWorldUnload() {
        MonitorRenderState.destroyAll();
        SpeakerManager.reset();
    }

    public static void onDisconnect() {
        ClientPocketComputers.reset();
    }

    public static boolean drawHighlight(class_4587 transform, class_4597 bufferSource, class_4184 camera, class_3965 hit) {
        return CableHighlightRenderer.drawHighlight(transform, bufferSource, camera, hit) || MonitorHighlightRenderer.drawHighlight(transform, bufferSource, camera, hit);
    }

    public static boolean onRenderHeldItem(class_4587 transform, class_4597 render, int lightTexture, class_1268 hand, float pitch, float equipProgress, float swingProgress, class_1799 stack) {
        if (stack.method_7909() instanceof PocketComputerItem) {
            PocketItemRenderer.INSTANCE.renderItemFirstPerson(transform, render, lightTexture, hand, pitch, equipProgress, swingProgress, stack);
            return true;
        }
        if (stack.method_7909() instanceof PrintoutItem) {
            PrintoutItemRenderer.INSTANCE.renderItemFirstPerson(transform, render, lightTexture, hand, pitch, equipProgress, swingProgress, stack);
            return true;
        }
        return false;
    }

    public static boolean onRenderItemFrame(class_4587 transform, class_4597 render, class_1533 frame, class_1799 stack, int light) {
        if (stack.method_7909() instanceof PrintoutItem) {
            PrintoutItemRenderer.onRenderInFrame(transform, render, frame, stack, light);
            return true;
        }
        return false;
    }

    public static void onPlayStreaming(class_1140 engine, class_4224 channel, class_4234 stream) {
        SpeakerManager.onPlayStreaming(engine, channel, stream);
    }

    public static void addBlockDebugInfo(Consumer<String> addText) {
        class_310 minecraft = class_310.method_1551();
        if (!minecraft.field_1690.field_1866 || minecraft.field_1687 == null) {
            return;
        }
        if (minecraft.field_1765 == null || minecraft.field_1765.method_17783() != class_239.class_240.field_1332) {
            return;
        }
        class_2586 tile = minecraft.field_1687.method_8321(((class_3965)minecraft.field_1765).method_17777());
        if (tile instanceof MonitorBlockEntity) {
            MonitorBlockEntity monitor = (MonitorBlockEntity)tile;
            addText.accept("");
            addText.accept(String.format("Targeted monitor: (%d, %d), %d x %d", monitor.getXIndex(), monitor.getYIndex(), monitor.getWidth(), monitor.getHeight()));
        } else if (tile instanceof TurtleBlockEntity) {
            TurtleBlockEntity turtle = (TurtleBlockEntity)tile;
            addText.accept("");
            addText.accept("Targeted turtle:");
            addText.accept(String.format("Id: %d", turtle.getComputerID()));
            ClientHooks.addTurtleUpgrade(addText, turtle, TurtleSide.LEFT);
            ClientHooks.addTurtleUpgrade(addText, turtle, TurtleSide.RIGHT);
        }
    }

    private static void addTurtleUpgrade(Consumer<String> out, TurtleBlockEntity turtle, TurtleSide side) {
        ITurtleUpgrade upgrade = turtle.getUpgrade(side);
        if (upgrade != null) {
            out.accept(String.format("Upgrade[%s]: %s", new Object[]{side, upgrade.getUpgradeID()}));
        }
    }

    public static void addGameDebugInfo(Consumer<String> addText) {
        if (MonitorBlockEntityRenderer.hasRenderedThisFrame() && class_310.method_1551().field_1690.field_1866) {
            addText.accept("[CC:T] Monitor renderer: " + String.valueOf((Object)MonitorBlockEntityRenderer.currentRenderer()));
        }
    }

    public static @Nullable class_2680 getBlockBreakingState(class_2680 state, class_2338 pos) {
        if (state.method_26204() != ModRegistry.Blocks.CABLE.get() || !((Boolean)state.method_11654((class_2769)CableBlock.CABLE)).booleanValue() || state.method_11654(CableBlock.MODEM) == CableModemVariant.None) {
            return null;
        }
        class_239 hit = class_310.method_1551().field_1765;
        if (hit == null || hit.method_17783() != class_239.class_240.field_1332) {
            return null;
        }
        class_2338 hitPos = ((class_3965)hit).method_17777();
        if (!hitPos.equals((Object)pos)) {
            return null;
        }
        return WorldUtil.isVecInside(CableShapes.getModemShape(state), hit.method_17784().method_1023((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260())) ? (class_2680)state.method_26204().method_9564().method_11657(CableBlock.MODEM, (Comparable)((Object)((CableModemVariant)((Object)state.method_11654(CableBlock.MODEM))))) : (class_2680)state.method_11657(CableBlock.MODEM, (Comparable)((Object)CableModemVariant.None));
    }
}

