/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.platform.helper.world.inventory;

import com.blamejared.crafttweaker.platform.helper.inventory.IInventoryWrapper;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.impl.transfer.item.ItemVariantImpl;
import net.minecraft.class_1799;

public class TAInventoryWrapper
implements IInventoryWrapper {
    private final InventoryStorage storage;

    public TAInventoryWrapper(InventoryStorage storage) {
        this.storage = storage;
    }

    @Override
    public int getContainerSize() {
        return this.storage.getSlots().size();
    }

    @Override
    public boolean canFitInSlot(int slot, class_1799 stack) {
        SingleSlotStorage storageSlot = this.storage.getSlot(slot);
        if (storageSlot.isResourceBlank()) {
            return true;
        }
        if (((ItemVariant)storageSlot.getResource()).matches(stack)) {
            int maxStackSize = (int)Math.min(storageSlot.getCapacity(), (long)stack.method_7914());
            return storageSlot.getAmount() + (long)stack.method_7947() < (long)maxStackSize;
        }
        return false;
    }

    @Override
    public class_1799 getItem(int slot) {
        SingleSlotStorage slotStorage = this.storage.getSlot(slot);
        return ((ItemVariant)slotStorage.getResource()).toStack((int)slotStorage.getAmount());
    }

    @Override
    public class_1799 insertItem(int slot, class_1799 stack, boolean simulate) {
        class_1799 copied = stack.method_7972();
        long needToInsert = stack.method_7947();
        ItemVariantImpl variant = new ItemVariantImpl(stack.method_7909(), stack.method_7969());
        if (slot >= 0 && slot < this.storage.getSlots().size()) {
            SingleSlotStorage storageSlot = this.storage.getSlot(slot);
            if (!this.storage.supportsInsertion() || !storageSlot.supportsInsertion()) {
                return stack;
            }
            if (storageSlot.isResourceBlank() || ((ItemVariant)storageSlot.getResource()).matches(stack)) {
                try (Transaction transaction = Transaction.openOuter();){
                    long insert = storageSlot.insert((Object)variant, needToInsert, (TransactionContext)transaction);
                    transaction.commit();
                    needToInsert -= insert;
                }
            }
        }
        if (needToInsert <= 0L) {
            return class_1799.field_8037;
        }
        copied.method_7939((int)needToInsert);
        return copied;
    }
}

