/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.registry.zencode;

import com.blamejared.crafttweaker.api.tag.manager.ITagManager;
import com.blamejared.crafttweaker.api.tag.manager.TagManagerFactory;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2378;
import net.minecraft.class_5321;

public class TaggableElementRegistry {
    private final Map<class_5321<?>, TagManagerFactory<?, ?>> managerData = new HashMap();
    private final Map<class_5321<?>, Class<?>> elementData = new HashMap();

    public <T, U extends ITagManager<?>> void registerManager(class_5321<T> id, TagManagerFactory<T, U> factory) {
        TagManagerFactory<?, ?> old = this.managerData.get(id);
        if (old != null) {
            throw new IllegalArgumentException("Attempted taggable element manager overriding on id " + id + ": old " + old + ", new " + factory);
        }
        this.managerData.put(id, factory);
    }

    public <T> void registerElement(class_5321<T> id, Class<T> clazz) {
        Class<?> old = this.elementData.get(id);
        if (old != null) {
            throw new IllegalArgumentException("Attempted taggable element overriding on id " + id + ": old " + old.getCanonicalName() + ", new " + clazz.getCanonicalName());
        }
        this.elementData.put(id, clazz);
    }

    public <T> Optional<Class<T>> getTaggableElement(class_5321<T> key) {
        return Optional.ofNullable(this.elementData.get(key)).map(it -> it);
    }

    public Map<class_5321<?>, Class<?>> getTaggableElements() {
        return ImmutableMap.copyOf(this.elementData);
    }

    public <T> Optional<TagManagerFactory<T, ? extends ITagManager<?>>> getManagerFactory(class_5321<class_2378<T>> key) {
        return Optional.ofNullable(this.managerData.get(key)).map(it -> it);
    }

    public Map<class_5321<?>, TagManagerFactory<?, ?>> getManagers() {
        return ImmutableMap.copyOf(this.managerData);
    }
}

