/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.command.type;

import com.blamejared.crafttweaker.api.bracket.custom.RecipeTypeBracketHandler;
import com.blamejared.crafttweaker.api.command.CommandUtilities;
import com.blamejared.crafttweaker.api.command.argument.RecipeTypeArgument;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.plugin.ICommandRegistrationHandler;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandlerRegistry;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import com.blamejared.crafttweaker.impl.helper.AccessibleElementsProvider;
import com.blamejared.crafttweaker.mixin.common.access.recipe.AccessRecipeManager;
import com.mojang.brigadier.arguments.ArgumentType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3956;
import net.minecraft.class_7923;

public final class RecipeCommands {
    private RecipeCommands() {
    }

    public static void registerCommands(ICommandRegistrationHandler handler) {
        handler.registerRootCommand("recipes", class_2561.method_43471((String)"crafttweaker.command.description.recipes"), builder -> builder.executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            return RecipeCommands.dumpRecipes((class_1657)player);
        }));
        handler.registerSubCommand("recipes", "hand", class_2561.method_43471((String)"crafttweaker.command.description.recipes.hand"), builder -> builder.executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            return RecipeCommands.dumpHand((class_1657)player, player.method_6047());
        }));
        handler.registerSubCommand("recipes", "inventory", class_2561.method_43471((String)"crafttweaker.command.description.recipes.inventory"), builder -> builder.executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            ArrayList<class_1799> stacks = new ArrayList<class_1799>();
            IntStream.range(0, player.method_31548().method_5439()).mapToObj(arg_0 -> ((class_1661)player.method_31548()).method_5438(arg_0)).filter(itemStack -> !itemStack.method_7960()).forEach(itemStack -> {
                if (stacks.stream().noneMatch(stack -> class_1799.method_7984((class_1799)itemStack, (class_1799)stack))) {
                    stacks.add((class_1799)itemStack);
                }
            });
            return RecipeCommands.dump((class_1657)player, stacks);
        }));
        handler.registerSubCommand("recipes", "manager", class_2561.method_43471((String)"crafttweaker.command.description.recipes.manager"), builder -> builder.then(class_2170.method_9244((String)"type", (ArgumentType)RecipeTypeArgument.get()).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            return RecipeCommands.dumpRecipes((class_1657)player, (IRecipeManager)context.getArgument("type", IRecipeManager.class));
        })));
    }

    private static int dumpRecipes(class_1657 player) {
        CommandUtilities.COMMAND_LOGGER.info("Dumping all recipes!");
        RecipeCommands.dumpRecipes(player, (class_3956<?> it) -> true);
        CommandUtilities.send(CommandUtilities.openingLogFile(class_2561.method_43469((String)"crafttweaker.command.list.check.log", (Object[])new Object[]{CommandUtilities.makeNoticeable(class_2561.method_43471((String)"crafttweaker.command.misc.recipes.list")), CommandUtilities.getFormattedLogFile()}).method_27692(class_124.field_1060)), player);
        return 1;
    }

    private static int dumpRecipes(class_1657 player, IRecipeManager<?> manager) {
        CommandUtilities.COMMAND_LOGGER.info("Dumping recipes for manager " + manager.getCommandString() + "!");
        class_3956<?> type = manager.getRecipeType();
        RecipeCommands.dumpRecipes(player, (class_3956<?> it) -> Objects.equals(it, type));
        CommandUtilities.send(CommandUtilities.openingLogFile(class_2561.method_43469((String)"crafttweaker.command.list.check.log", (Object[])new Object[]{CommandUtilities.makeNoticeable(class_2561.method_43471((String)"crafttweaker.command.misc.recipes.list")), CommandUtilities.getFormattedLogFile()}).method_27692(class_124.field_1060)), player);
        return 1;
    }

    private static int dumpHand(class_1657 player, class_1799 stack) {
        return RecipeCommands.dump(player, List.of(stack));
    }

    private static int dump(class_1657 player, List<class_1799> stacks) {
        for (class_1799 stack : stacks) {
            if (stack.method_7960()) {
                CommandUtilities.send((class_2561)class_2561.method_43471((String)"crafttweaker.command.recipes.hand.empty").method_27692(class_124.field_1061), player);
                return 1;
            }
            IItemStack workingStack = IItemStack.of(stack.method_7972()).setAmount(1);
            CommandUtilities.COMMAND_LOGGER.info("Dumping all recipes that output {}!", (Object)ItemStackUtil.getCommandString(workingStack.getInternal()));
            ((AccessRecipeManager)player.method_37908().method_8433()).crafttweaker$getRecipes().forEach((recipeType, map) -> RecipeCommands.dumpRecipe(recipeType, map.values(), it -> workingStack.matches(IItemStack.of(AccessibleElementsProvider.get().registryAccess(arg_0 -> ((class_1860)it).method_8110(arg_0)))), true));
        }
        CommandUtilities.send(CommandUtilities.openingLogFile(class_2561.method_43469((String)"crafttweaker.command.list.check.log", (Object[])new Object[]{CommandUtilities.makeNoticeable(class_2561.method_43471((String)"crafttweaker.command.misc.recipes.list")), CommandUtilities.getFormattedLogFile()}).method_27692(class_124.field_1060)), player);
        return 1;
    }

    private static void dumpRecipes(class_1657 player, Predicate<class_3956<?>> typeFilter) {
        ((AccessRecipeManager)player.method_37908().method_8433()).crafttweaker$getRecipes().entrySet().stream().filter(it -> typeFilter.test((class_3956)it.getKey())).forEach(it -> RecipeCommands.dumpRecipe((class_3956)it.getKey(), ((Map)it.getValue()).values(), recipe -> true, false));
    }

    private static void dumpRecipe(class_3956<?> type, Collection<class_1860<?>> recipes, Predicate<class_1860<?>> filter, boolean hideEmpty) {
        IRecipeManager<class_1860<?>> manager = RecipeTypeBracketHandler.getOrDefault(type);
        if (manager == null) {
            return;
        }
        String dumpResult = recipes.stream().filter(filter).sorted(Comparator.comparing(RecipeCommands::serializer).thenComparing(class_1860::method_8114)).map(it -> RecipeCommands.dump((IRecipeManager)GenericUtil.uncheck(manager), it)).collect(Collectors.joining("\n  "));
        if (hideEmpty && dumpResult.isEmpty()) {
            return;
        }
        CommandUtilities.COMMAND_LOGGER.info("Recipe type: '{}'\n  {}\n", (Object)manager.getCommandString(), (Object)(dumpResult.isEmpty() ? "No recipe found" : dumpResult));
    }

    private static class_2960 serializer(class_1860<?> recipe) {
        return Objects.requireNonNull(class_7923.field_41189.method_10221((Object)recipe.method_8119()));
    }

    private static <T extends class_1860<?>> String dump(IRecipeManager<? super T> manager, T recipe) {
        return IRecipeHandlerRegistry.getHandlerFor(recipe).dumpToCommandString(manager, (T)recipe);
    }
}

