/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe.type;

import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.MirrorAxis;
import com.blamejared.crafttweaker.api.recipe.fun.RecipeFunction2D;
import com.blamejared.crafttweaker.api.recipe.serializer.CTShapedRecipeSerializer;
import com.blamejared.crafttweaker.api.util.ArrayUtil;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_8566;

public class CTShapedRecipe
extends class_1869 {
    private static final Pair<Integer, Integer> INVALID = Pair.of((Object)-1, (Object)-1);
    private final IIngredient[][] ingredients;
    private final IIngredient[][][] mirroredIngredients;
    private final IItemStack output;
    private final MirrorAxis mirrorAxis;
    @Nullable
    private final RecipeFunction2D function;

    public CTShapedRecipe(String name, IItemStack output, IIngredient[][] ingredients, MirrorAxis mirrorAxis, @Nullable RecipeFunction2D function) {
        this(name, class_7710.field_40251, output, ingredients, mirrorAxis, function);
    }

    public CTShapedRecipe(String name, class_7710 category, IItemStack output, IIngredient[][] ingredients, MirrorAxis mirrorAxis, @Nullable RecipeFunction2D function) {
        super(CraftTweakerConstants.rl(name), "", category, CTShapedRecipe.getMaxWidth(ingredients), ingredients.length, class_2371.method_10211(), output.getInternal());
        this.output = output;
        this.ingredients = ingredients;
        this.mirrorAxis = mirrorAxis;
        this.function = function;
        this.mirroredIngredients = new IIngredient[MirrorAxis.values().length][][];
        for (int index = 0; index < this.ingredients.length; ++index) {
            if (this.ingredients[index].length >= this.method_8150()) continue;
            this.ingredients[index] = ArrayUtil.copyOf(this.ingredients[index], this.method_8150(), IItemStack.empty());
        }
        this.initMirroredIngredients();
    }

    private static int getMaxWidth(IIngredient[][] array) {
        return Arrays.stream(array).mapToInt(row -> ((IIngredient[])row).length).max().orElse(0);
    }

    private void initMirroredIngredients() {
        this.mirroredIngredients[MirrorAxis.NONE.ordinal()] = this.ingredients;
        if (this.mirrorAxis.isMirrored()) {
            int i;
            IIngredient[][] workingIngredients;
            if (this.mirrorAxis.isVertical()) {
                this.mirroredIngredients[MirrorAxis.VERTICAL.ordinal()] = (IIngredient[][])ArrayUtil.mirror(this.ingredients);
            }
            if (this.mirrorAxis.isHorizontal()) {
                workingIngredients = (IIngredient[][])ArrayUtil.copy(this.ingredients);
                for (i = 0; i < workingIngredients.length; ++i) {
                    workingIngredients[i] = ArrayUtil.mirror(workingIngredients[i]);
                }
                this.mirroredIngredients[MirrorAxis.HORIZONTAL.ordinal()] = workingIngredients;
            }
            if (this.mirrorAxis.isDiagonal()) {
                workingIngredients = (IIngredient[][])ArrayUtil.mirror(this.ingredients);
                for (i = 0; i < workingIngredients.length; ++i) {
                    workingIngredients[i] = ArrayUtil.mirror(workingIngredients[i]);
                }
                this.mirroredIngredients[MirrorAxis.DIAGONAL.ordinal()] = workingIngredients;
            }
        }
    }

    private Pair<Integer, Integer> calculateOffset(class_8566 inv) {
        Pair<Integer, Integer> offset = this.calculateOffset(this.mirroredIngredients[MirrorAxis.NONE.ordinal()], inv);
        if (this.isValidOffset(offset) || !this.mirrorAxis.isMirrored()) {
            return offset;
        }
        if (this.mirrorAxis.isVertical() && this.isValidOffset(offset = this.calculateOffset(this.mirroredIngredients[MirrorAxis.VERTICAL.ordinal()], inv))) {
            return offset;
        }
        if (this.mirrorAxis.isHorizontal() && this.isValidOffset(offset = this.calculateOffset(this.mirroredIngredients[MirrorAxis.HORIZONTAL.ordinal()], inv))) {
            return offset;
        }
        if (this.mirrorAxis.isDiagonal() && this.isValidOffset(offset = this.calculateOffset(this.mirroredIngredients[MirrorAxis.DIAGONAL.ordinal()], inv))) {
            return offset;
        }
        return INVALID;
    }

    private Pair<Integer, Integer> calculateOffset(IIngredient[][] test, class_8566 inv) {
        for (int rowOffset = 0; rowOffset <= inv.method_17397() - test.length; ++rowOffset) {
            block1: for (int columnOffset = 0; columnOffset <= inv.method_17398() - test[0].length; ++columnOffset) {
                boolean[] visited = new boolean[inv.method_5439()];
                for (int rowIndex = 0; rowIndex < test.length; ++rowIndex) {
                    IIngredient[] row = test[rowIndex];
                    for (int columnIndex = 0; columnIndex < row.length; ++columnIndex) {
                        IIngredient item = row[columnIndex];
                        int slotNumber = (rowIndex + rowOffset) * inv.method_17398() + columnIndex + columnOffset;
                        class_1799 stackInSlot = inv.method_5438(slotNumber);
                        if (item == null && !stackInSlot.method_7960() || item != null && !item.matches(IItemStack.ofMutable(stackInSlot))) continue block1;
                        visited[slotNumber] = true;
                    }
                }
                for (int i = 0; i < visited.length; ++i) {
                    if (!visited[i] && !inv.method_5438(i).method_7960()) continue block1;
                }
                return Pair.of((Object)rowOffset, (Object)columnOffset);
            }
        }
        return INVALID;
    }

    public boolean method_17728(class_8566 inv, @Nullable class_1937 worldIn) {
        return this.isValidOffset(this.calculateOffset(inv));
    }

    public class_1799 method_17727(class_8566 container, class_5455 access) {
        Pair<Integer, Integer> offset = this.calculateOffset(container);
        if (offset == INVALID) {
            return class_1799.field_8037;
        }
        if (this.function == null) {
            return this.method_8110(access);
        }
        int rowOffset = (Integer)offset.getFirst();
        int columnOffset = (Integer)offset.getSecond();
        IItemStack[][] stacks = new IItemStack[this.method_8158()][this.method_8150()];
        for (int rowIndex = 0; rowIndex < this.ingredients.length; ++rowIndex) {
            IIngredient[] row = this.ingredients[rowIndex];
            for (int columnIndex = 0; columnIndex < row.length; ++columnIndex) {
                IIngredient ingredient = row[columnIndex];
                if (ingredient == null) continue;
                int slotIndex = (rowIndex + rowOffset) * container.method_17398() + columnIndex + columnOffset;
                stacks[rowIndex][columnIndex] = IItemStack.of(container.method_5438(slotIndex)).setAmount(1);
            }
        }
        return this.function.process(this.output, stacks).getImmutableInternal();
    }

    public class_1799 method_8110(class_5455 access) {
        return this.output.getInternal().method_7972();
    }

    public class_2371<class_1799> getRemainingItems(class_8566 inv) {
        IIngredient[][] workingIngredients = this.mirroredIngredients[MirrorAxis.NONE.ordinal()];
        Pair<Integer, Integer> offset = this.calculateOffset(workingIngredients, inv);
        if (offset != INVALID || !this.mirrorAxis.isMirrored()) {
            return this.getRemainingItems(inv, offset, workingIngredients);
        }
        if (this.mirrorAxis.isVertical() && (offset = this.calculateOffset(workingIngredients = this.mirroredIngredients[MirrorAxis.VERTICAL.ordinal()], inv)) != INVALID) {
            return this.getRemainingItems(inv, offset, workingIngredients);
        }
        if (this.mirrorAxis.isHorizontal() && (offset = this.calculateOffset(workingIngredients = this.mirroredIngredients[MirrorAxis.HORIZONTAL.ordinal()], inv)) != INVALID) {
            return this.getRemainingItems(inv, offset, workingIngredients);
        }
        if (this.mirrorAxis.isDiagonal()) {
            workingIngredients = this.mirroredIngredients[MirrorAxis.DIAGONAL.ordinal()];
            offset = this.calculateOffset(workingIngredients, inv);
        }
        return this.getRemainingItems(inv, offset, workingIngredients);
    }

    public class_2371<class_1799> getRemainingItems(class_8566 inv, Pair<Integer, Integer> offsetPair, IIngredient[][] ingredients) {
        class_2371 result = class_2371.method_10213((int)inv.method_5439(), (Object)class_1799.field_8037);
        if (offsetPair == INVALID) {
            return result;
        }
        int rowOffset = (Integer)offsetPair.getFirst();
        int columnOffset = (Integer)offsetPair.getSecond();
        for (int rowIndex = 0; rowIndex < ingredients.length; ++rowIndex) {
            IIngredient[] row = ingredients[rowIndex];
            for (int columnIndex = 0; columnIndex < row.length; ++columnIndex) {
                IIngredient ingredient = row[columnIndex];
                if (ingredient == null) continue;
                int slotIndex = (rowIndex + rowOffset) * inv.method_17398() + columnIndex + columnOffset;
                result.set(slotIndex, (Object)ingredient.getRemainingItem(IItemStack.ofMutable(inv.method_5438(slotIndex))).getInternal());
            }
        }
        return result;
    }

    public class_2371<class_1856> method_8117() {
        class_2371 ingredients = class_2371.method_10213((int)(this.method_8158() * this.method_8150()), (Object)class_1856.field_9017);
        for (int row = 0; row < this.ingredients.length; ++row) {
            IIngredient[] ingredientRow = this.ingredients[row];
            for (int column = 0; column < ingredientRow.length; ++column) {
                ingredients.set(row * this.method_8150() + column, (Object)ingredientRow[column].asVanillaIngredient());
            }
        }
        return ingredients;
    }

    public class_1865<CTShapedRecipe> method_8119() {
        return CTShapedRecipeSerializer.INSTANCE;
    }

    public IIngredient[][] getCtIngredients() {
        return this.ingredients;
    }

    public IItemStack getCtOutput() {
        return this.output;
    }

    @Nullable
    public RecipeFunction2D getFunction() {
        return this.function;
    }

    public boolean isMirrored() {
        return this.mirrorAxis.isMirrored();
    }

    public MirrorAxis getMirrorAxis() {
        return this.mirrorAxis;
    }

    private boolean isValidOffset(Pair<Integer, Integer> pair) {
        return !pair.equals(INVALID);
    }

    public boolean method_31584() {
        class_2371<class_1856> ingredients = this.method_8117();
        return ingredients.isEmpty() || ingredients.stream().filter(ingredient -> !ingredient.method_8103()).anyMatch(ingredient -> ingredient.method_8105().length == 0);
    }
}

