/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe.replacement.type;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.bracket.custom.RecipeTypeBracketHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.recipe.replacement.IFilteringRule;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1263;
import net.minecraft.class_1860;
import org.openzen.zencode.java.ZenCodeType;

@Document(value="vanilla/api/recipe/replacement/type/CustomFilteringRule")
@ZenCodeType.Name(value="crafttweaker.api.recipe.replacement.type.CustomFilteringRule")
@ZenRegister
public final class CustomFilteringRule
implements IFilteringRule {
    private final BiPredicate<IRecipeManager<?>, class_1860<?>> predicate;
    private final boolean requiresComputation;

    private CustomFilteringRule(BiPredicate<IRecipeManager<?>, class_1860<?>> predicate, boolean requiresComputation) {
        this.predicate = predicate;
        this.requiresComputation = requiresComputation;
    }

    public static CustomFilteringRule of(Predicate<class_1860<?>> predicate) {
        return new CustomFilteringRule((a, b) -> predicate.test((class_1860<?>)b), false);
    }

    public static CustomFilteringRule of(BiPredicate<IRecipeManager<?>, class_1860<?>> predicate) {
        return new CustomFilteringRule(predicate, true);
    }

    @ZenCodeType.Method(value="of")
    public static CustomFilteringRule ofZen(Predicate<class_1860<class_1263>> predicate) {
        return CustomFilteringRule.of((Predicate)GenericUtil.uncheck(predicate));
    }

    @ZenCodeType.Method(value="of")
    public static CustomFilteringRule ofZen(BiPredicate<IRecipeManager<class_1860<class_1263>>, class_1860<class_1263>> predicate) {
        return CustomFilteringRule.of((BiPredicate)GenericUtil.uncheck(predicate));
    }

    @Override
    public Stream<? extends class_1860<?>> castFilter(Stream<? extends class_1860<?>> allRecipes) {
        return allRecipes.filter(this::castFilter);
    }

    @Override
    public String describe() {
        return "a custom set of recipes";
    }

    private <C extends class_1263, T extends class_1860<C>> boolean castFilter(T recipe) {
        IRecipeManager manager = this.requiresComputation ? (IRecipeManager)GenericUtil.uncheck(RecipeTypeBracketHandler.getOrDefault(recipe.method_17716())) : null;
        return this.predicate.test(manager, recipe);
    }
}

