/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.action.recipe;

import com.blamejared.crafttweaker.api.action.recipe.ActionRecipeBase;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.class_1860;
import net.minecraft.class_2960;
import org.apache.logging.log4j.Logger;

public class ActionRemoveRecipeByName<T extends class_1860<?>>
extends ActionRecipeBase<T> {
    private final class_2960[] names;

    public ActionRemoveRecipeByName(IRecipeManager<T> manager, class_2960 name) {
        super(manager);
        this.names = new class_2960[]{name};
    }

    public ActionRemoveRecipeByName(IRecipeManager<T> manager, class_2960 ... names) {
        super(manager);
        this.names = names;
    }

    @Override
    public void apply() {
        for (class_2960 name : this.names) {
            this.getRecipeMutator().remove(name);
        }
    }

    @Override
    public String describe() {
        return "Removing '" + this.getRecipeTypeName() + "' recipe(s) with name(s): '" + Arrays.stream(this.names).map(class_2960::toString).collect(Collectors.joining(", ", "[", "]")) + "'";
    }

    @Override
    public boolean validate(Logger logger) {
        boolean containsKey = true;
        for (class_2960 name : this.names) {
            boolean contains = this.getRecipeMutator().has(name);
            if (contains) continue;
            logger.warn("No recipe with type: '{}' and name: '{}'", (Object)this.getRecipeTypeName(), (Object)name);
            containsKey = false;
        }
        return containsKey;
    }
}

